#include <cv.h>
#include <cxcore.h>
#include <highgui.h>
#include <math.h>
#include <iostream>
#include <fstream>

#include <XnOS.h>
#include <XnCppWrapper.h>
#include "cam.h"

using namespace std;
using namespace cv;
using namespace xn;

//---------------------------------------------------------------------------
// Defines
//---------------------------------------------------------------------------
#define SAMPLE_XML_PATH "SamplesConfig.xml"

//---------------------------------------------------------------------------
// Globals
//---------------------------------------------------------------------------
Context g_context;
DepthGenerator g_depth;
ImageGenerator g_image;
DepthMetaData g_depthMD;
ImageMetaData g_imageMD;

void GlViewColor(IplImage *depth, IplImage *depthUB, IplImage *depthLB)
{
	if (!depthUB) depthUB = cvCreateImage(cvSize(640,480), 8, 1);
	if (!depthLB) depthLB = cvCreateImage(cvSize(640,480), 8, 1);
	unsigned char *depth_UB = (unsigned char *)(depthUB->imageData);
	unsigned char *depth_LB = (unsigned char *)(depthLB->imageData);
	int i;
	for (i = 0; i < 640*480; i++) {
		int lb = ((short *)depth->imageData)[i] % 256;
		int ub = ((short *)depth->imageData)[i] / 256;

		//depth_mid[3*i+2] = ub;
		//depth_mid[3*i+1] = ub;
		depth_LB[i] = lb;
		depth_UB[i] = ub*30;
	}
}

//retrieve new frame
int capture(IplImage *img, IplImage *depth) {
	// Read a new frame
	XnStatus rc = XN_STATUS_OK;
	rc = g_context.WaitAnyUpdateAll();
	if (rc != XN_STATUS_OK)
	{
		printf("Read failed: %s\n", xnGetStatusString(rc));
		return 0;
	}

	g_depth.GetMetaData(g_depthMD);
	g_image.GetMetaData(g_imageMD);

	const XnDepthPixel* pDepth = g_depthMD.Data();
	const XnUInt8* pImage = g_imageMD.Data();

	//store images
	char *data = 0;
	memcpy(img->imageData, pImage, 640*480*3*sizeof(char));
	cvCvtColor(img, img, CV_BGR2RGB);

	data = 0;
	memcpy(depth->imageData, pDepth, 640*480*2*sizeof(char));

	cvFlip(depth, depth, 1);
	cvFlip(img, img, 1);

	return 1;
}

int main(int argc, char* argv[])
{
	XnStatus rc;

	//windows
	cvNamedWindow("win1", 1);
	cvNamedWindow("win2", 1);
	cvNamedWindow("win3", 1);

	//images
	IplImage *image = cvCreateImage(cvSize(640, 480), 8, 3);
	IplImage *depth = cvCreateImage(cvSize(640, 480), 16, 1);

	//file save
	ofstream saveUB, saveLB;
	CvMat stub, *saveMat;

	///////////////////////////////////////////
	saveUB.open ("save_ub.bin", ios::out | ios::binary);
	saveLB.open ("save_lb.bin", ios::out | ios::binary);

	EnumerationErrors errors;
	rc = g_context.InitFromXmlFile(SAMPLE_XML_PATH, &errors);
	if (rc == XN_STATUS_NO_NODE_PRESENT)
	{
		XnChar strError[1024];
		errors.ToString(strError, 1024);
		printf("%s\n", strError);
		return (rc);
	}
	else if (rc != XN_STATUS_OK)
	{
		printf("Open failed: %s\n", xnGetStatusString(rc));
		return (rc);
	}

	rc = g_context.FindExistingNode(XN_NODE_TYPE_DEPTH, g_depth);
	rc = g_context.FindExistingNode(XN_NODE_TYPE_IMAGE, g_image);


	int cycle = 1;
	int saving = 1;
	int init  = 0;

	IplImage *depthUB, *depthLB;
	depthUB = cvCreateImage(cvSize(640,480), 8, 1);
	depthLB = cvCreateImage(cvSize(640,480), 8, 1);

	//while(cycle) {

		//printf("%d\n", depth->imageSize);

		//get new frame
		if(capture(image, depth) == 0)
			return 0;

		GlViewColor(depth, depthUB, depthLB);

		cvShowImage("win1", depthUB);
		cvShowImage("win2", depthLB);
		char c = cvWaitKey(0);

		//save data to file
		if(saving == 1 && saveUB.is_open() && saveLB.is_open()) 
		{
			//convert to Mat
			//saveMat = cvGetMat( depth, &stub, 0, 0);
			//save
			/*for(int a = 0; a < depth->width*depth->height; a+=1) {
				short ass = *(depth->imageData+a);
				savefile.write((char*)&ass, sizeof(ass));
			}*/

			saveUB.write((char*)(depthUB->imageData), depthUB->imageSize);
			//saveLB.write((char*)(depthLB->imageData), depthLB->imageSize);
			
		}

		if(c == 'a') {
			saving = 1;
		} else if (c == 'x') {
			cycle = 0;
		}

	//}

	saveUB.flush();
	saveLB.flush();
	saveUB.close();
	saveLB.close();

	//tst
	IplImage *depth2 = cvCreateImage(cvSize(640, 480), 8, 1);
	//IplImage *depth3 = cvCreateImage(cvSize(640, 480), 8, 1);
	ifstream loadUB, loadLB;
	loadUB.open("saveUB.bin");
	//loadLB.open("saveLB.bin");

	loadUB.seekg(0, ios::beg);
	//loadLB.seekg(0, ios::beg);
	//for(int a = 0; a < depth->width*depth->height; a+=1)
	//	loadfile.read((char*)(depth2->imageData+a*2), 2);
	loadUB.read((char*)depth2->imageData, depth2->imageSize);
	//loadLB.read((char*)depth3->imageData, depth3->imageSize);

	cvShowImage("win1", depth);
	cvShowImage("win2", depth2);
	//cvShowImage("win3", depth3);

	cvWaitKey(0);

	loadUB.close();
	loadLB.close();

	return 0;
}